IF NOT EXISTS(SELECT * 
              FROM   INFORMATION_SCHEMA.TABLES 
              WHERE  TABLE_NAME = 'INTEGRA_BENNER_LOG') 

BEGIN
	CREATE TABLE [dbo].[INTEGRA_BENNER_LOG] 
	  ( 
		 [ID]               [UNIQUEIDENTIFIER] NOT NULL, 
		 [ID_EVENTO]        [UNIQUEIDENTIFIER] NOT NULL,
		 [DT_PROCESSAMENTO] [DATETIME] NOT NULL,
		 [MENSAGEM]         [TEXT], 
		 [RESPOSTA]         [TEXT],
		 CONSTRAINT [PK_INTEGRA_BENNER_LOG] PRIMARY KEY CLUSTERED ( [ID] ASC )WITH ( 
		 PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, 
		 ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY] 
	  ) 
	ON [PRIMARY] 

	ALTER TABLE [dbo].[INTEGRA_BENNER_LOG] 
	  WITH CHECK ADD CONSTRAINT [FK_INTEGRA_BENNER_LOG_INTEGRA_BENNER_EVENTOS_ID] FOREIGN KEY 
	  ([ID_EVENTO]) REFERENCES [dbo].[INTEGRA_BENNER_EVENTOS] ([ID]) 

	ALTER TABLE [dbo].[INTEGRA_BENNER_LOG] 
	  CHECK CONSTRAINT [FK_INTEGRA_BENNER_LOG_INTEGRA_BENNER_EVENTOS_ID] 
	  
  	ALTER TABLE [dbo].[INTEGRA_BENNER_LOG] ADD  DEFAULT (getdate()) FOR [DT_PROCESSAMENTO]

	ALTER TABLE [dbo].[INTEGRA_BENNER_LOG] ADD  DEFAULT (newid()) FOR [ID]
END